# 画面設計書 54-メール通知（HTML - デフォルト）

## 概要

本ドキュメントは、Symfony 8.1のTwig Bridgeが提供するデフォルトスタイルのHTML形式メール通知テンプレート（`default/notification/body.html.twig`）の画面設計書である。このテンプレートは、SymfonyのNotifierコンポーネントと連携してHTML形式の通知メールを生成する。デフォルトテーマは実質的にZurb 2テーマ（No.56）を継承しており、スタイルのカスタマイズなしにZurb 2テーマのレイアウトをそのまま使用する。

### 本画面の処理概要

**業務上の目的・背景**：Webアプリケーションにおいて、システムイベントやユーザーアクション（パスワードリセット、注文確認等）に伴う通知メールは不可欠な機能である。SymfonyのNotifierコンポーネントは、メール・SMS・チャット等の複数チャネルへの通知送信を統一的に管理する。本テンプレートは、NotifierコンポーネントがメールチャネルでHTML形式の通知を送信する際のデフォルトHTMLテンプレートであり、Zurb 2（Foundation for Emails 2）フレームワークに基づくレスポンシブなメールレイアウトを提供する。`NotificationEmail`クラスの`theme`プロパティが`default`（デフォルト値）の場合にこのテンプレートが使用される。

**画面へのアクセス方法**：本テンプレートはWebブラウザでアクセスするものではなく、メールクライアント（Gmail、Outlook等）で受信・表示される。`NotificationEmail`クラスを使用してメールを送信すると、このテンプレートが自動的にレンダリングされてメール本文となる。

**主要な操作・処理内容**：
1. メール件名の表示 - `email.subject`変数を使用して通知メールの件名を`p.lead`タグで表示する
2. 重要度ラベルの表示 - `importance`変数（urgent/high/medium/low）に基づいて重要度ラベルを大文字で表示し、コンテナの上部ボーダー色を切替える
3. コンテンツ本文の表示 - Markdown形式、HTML生テキスト（raw）、プレーンテキスト（nl2br変換）の3形式に対応したコンテンツ表示
4. アクションボタンの表示 - `action_url`と`action_text`が指定されている場合、CTAボタンを表示する
5. 例外情報の表示 - 例外が添付されている場合、スタックトレースが添付されている旨のメッセージを表示する
6. フッターテキストの表示 - `footer_text`変数が定義されている場合、セカンダリセクションにフッターテキストを表示する

**画面遷移**：メール内のアクションボタンをクリックすると、`action_url`で指定されたURLに遷移する。それ以外の画面遷移は存在しない。

**権限による表示制御**：`importance`変数によってメールの視覚的な表現が変化する。`urgent`の場合はアラート（赤）、`high`の場合は警告（黄）、それ以外はデフォルト（グレー）の上部ボーダーが表示される。`markAsPublic()`メソッドを使用すると、`importance`と`footer_text`がnullに設定され、管理者向け情報が非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 41 | Notifier | 主機能 | Notifierコンポーネントからのメール通知トリガーによるHTMLメールテンプレートのレンダリング |
| 40 | Mailer | 補助機能 | Mailerコンポーネントによるメール送信処理 |
| 42 | Mime | 補助機能 | MIMEメッセージとしてのHTMLメール本文構成 |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのメール通知テンプレートによるHTMLレンダリング |

## 画面種別

メールテンプレート（HTML形式メール通知）

## URL/ルーティング

本テンプレートはWebルーティングではなく、Twigテンプレートパスで参照される。

| パス | 説明 |
|-----|------|
| `@email/default/notification/body.html.twig` | デフォルトテーマのHTMLメール通知テンプレート |
| `@email/zurb_2/notification/body.html.twig` | 実際のレイアウト定義（継承元） |

## 入出力項目

| 変数名 | 型 | 必須 | デフォルト値 | 説明 |
|--------|-----|------|-------------|------|
| email.subject | string | Yes | - | メール件名 |
| importance | string/null | No | `low` | 重要度（urgent/high/medium/low/null） |
| content | string | No | `''` | メール本文コンテンツ |
| markdown | bool | No | `false` | Markdown形式のコンテンツかどうか |
| raw | bool | No | `false` | HTMLをエスケープせずに出力するかどうか |
| action_url | string/null | No | `null` | アクションボタンのリンク先URL |
| action_text | string/null | No | `null` | アクションボタンのテキスト |
| exception | bool | No | `false` | 例外スタックトレースが添付されているかどうか |
| footer_text | string/null | No | `Notification email sent by Symfony` | フッターテキスト |

## 表示項目

| 表示セクション | HTML要素 | CSSクラス/スタイル | 説明 |
|---------------|---------|-------------------|------|
| 重要度ラベル | `<small><strong>` | - | importance値を大文字で表示（importance != null時のみ） |
| メール件名 | `<p class="lead">` | lead（font-size: 20px） | メール件名を目立つサイズで表示 |
| コンテンツ本文 | テキスト/Markdown/HTML | - | 3形式に対応した本文表示 |
| アクションボタン | `<button href="...">` | Inkyボタン | CTA用のリンクボタン（action_url指定時のみ） |
| 例外通知 | `<p><em>` | - | 例外スタックトレース添付の通知（exception == true時のみ） |
| フッター | `<p><small>` | secondary wrapper | フッターテキスト（footer_text指定時のみ） |
| コンテナボーダー | container | body_alert/body_warning/body_default | importanceに応じた上部ボーダー色 |

## イベント仕様

### 1-メール送信トリガー

`NotificationEmail`クラスのインスタンスが`Mailer`コンポーネントを通じて送信される際に、本テンプレートがレンダリングされる。`NotificationEmail::getHtmlTemplate()`が`@email/default/notification/body.html.twig`を返し、Twig Environmentがレンダリングを実行する。

### 2-重要度に応じたスタイル切替

`importance`変数の値に応じて、コンテナの上部ボーダー色が切替わる。
- `urgent`: `body_alert`クラス（赤色ボーダー: `#ec5840`）
- `high`: `body_warning`クラス（黄色ボーダー: `#ffae00`）
- `medium`/`low`/その他: `body_default`クラス（グレーボーダー: `#aaaaaa`）

### 3-コンテンツ形式の切替

`markdown`変数と`raw`変数の組み合わせで本文のレンダリング方式が決定される。
- `markdown == true`: `content_markdown.html.twig`テンプレートで`markdown_to_html`フィルタを適用
- `raw == true`: `content|raw`でHTMLをそのまま出力
- それ以外: `content|nl2br`で改行をBRタグに変換して出力

## データベース更新仕様

### 操作別データベース影響一覧

本テンプレートはメールのHTML生成のみを担当し、データベース操作は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージ種別 | 表示条件 | 表示形式 | 内容 |
|---------------|---------|---------|------|
| 重要度ラベル | `importance is not null` | `<small><strong>URGENT</strong></small>` 等 | 重要度を大文字で表示 |
| 例外通知メッセージ | `exception == true` | `<p><em>Exception stack trace attached.</em></p>` | 例外スタックトレースが添付されている旨の通知 |
| デフォルトフッター | `footer_text != null` | `<p><small>Notification email sent by Symfony</small></p>` | フッターテキスト |

## 例外処理

- `NotificationEmail`クラスのコンストラクタで`twig/cssinliner-extra`および`twig/inky-extra`パッケージの存在を検証し、不足時に`LogicException`をスローする
- `markdown()`メソッドで`twig/markdown-extra`パッケージの存在を検証し、不足時に`LogicException`をスローする
- テンプレートの読み込みに失敗した場合は、Twigのテンプレートローダーが例外をスローする

## 備考

- デフォルトテーマのHTMLテンプレート（`default/notification/body.html.twig`）は1行のみで、Zurb 2テーマ（`zurb_2/notification/body.html.twig`）を`{% extends %}`で継承している
- Zurb 2テーマはFoundation for Emails 2（Inky）フレームワークを使用しており、`{% apply inky_to_html|inline_css %}`でInkyマークアップからHTMLへの変換とCSSインライン化を行う
- CSS スタイルは`@email/zurb_2/main.css`（Foundation for Emails 2のベースCSS）と`@email/zurb_2/notification/local.css`（通知固有のCSS）を`source()`関数で読み込む
- `NotificationEmail::asPublicEmail()`で生成すると、`importance`と`footer_text`がnullに設定され、内部向け情報が非表示になる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

`NotificationEmail`クラスのコンテキスト（テンプレート変数）の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationEmail.php | `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php` | テンプレートに渡されるコンテキスト変数の定義（行33-42のcontext配列）。importance、content、exception、action_text、action_url、markdown、raw、footer_textの各変数を確認 |

**読解のコツ**: `NotificationEmail`クラスの`$context`配列がテンプレート変数のデフォルト値を定義している。`getHtmlTemplate()`（行168-175）で`@email/{theme}/notification/body.html.twig`パスが返される仕組みを理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | body.html.twig（default） | `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.html.twig` | デフォルトテーマのエントリーポイント。1行のみで`zurb_2/notification/body.html.twig`を継承 |

**主要処理フロー**:
1. **行1**: `{% extends '@email/zurb_2/notification/body.html.twig' %}` - Zurb 2テーマの継承

#### Step 3: Zurb 2テーマの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | body.html.twig（zurb_2） | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.html.twig` | 実際のHTMLレイアウト定義（67行）。Inkyマークアップによるメール構造 |

**主要処理フロー**:
1. **行1**: `{% apply inky_to_html|inline_css %}` - Inky変換とCSSインライン化の開始
2. **行5-8**: styleブロック - `main.css`と`local.css`の読み込み
3. **行14**: コンテナクラスの動的切替 - `body_alert`/`body_warning`/`body_default`
4. **行18-23**: leadブロック - 重要度ラベルとメール件名の表示
5. **行25-31**: contentブロック - Markdown/raw/nl2brの3形式対応
6. **行33-38**: actionブロック - CTAボタンの表示
7. **行40-45**: exceptionブロック - 例外通知の表示
8. **行49-61**: footerブロック - フッターテキストの表示

#### Step 4: CSSスタイルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | main.css | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/main.css` | Foundation for Emails 2のベースCSS。グリッドシステム、タイポグラフィ、ボタンスタイル等 |
| 4-2 | local.css | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/local.css` | 通知固有のCSS。body_alert/body_warning/body_defaultの上部ボーダー色 |

### プログラム呼び出し階層図

```
NotificationEmail::send()
    |
    +-- Mailer（メール送信処理）
    |       |
    |       +-- BodyRenderer（テンプレートレンダリング）
    |               |
    |               +-- Twig Environment
    |                       |
    |                       +-- body.html.twig（default）
    |                       |       |
    |                       |       +-- body.html.twig（zurb_2）
    |                       |               |
    |                       |               +-- {% apply inky_to_html|inline_css %}
    |                       |               +-- source('@email/zurb_2/main.css')
    |                       |               +-- source('@email/zurb_2/notification/local.css')
    |                       |               +-- content_markdown.html.twig（Markdown時）
    |                       |
    |                       +-- NotificationEmail::getContext()
    |                               |
    |                               +-- importance, content, action_url, etc.
```

### データフロー図

```
[入力]                              [処理]                              [出力]

NotificationEmail                   body.html.twig (default)            HTML形式
├── importance (urgent/high/...)     └── body.html.twig (zurb_2)        メール本文
├── content (テキスト/MD)                ├── Inky変換                   ├── レスポンシブHTML
├── action_url/text                      ├── CSS Inline化              ├── インラインCSS
├── exception (bool)                     ├── Markdown変換（任意）       ├── CTAボタン
├── footer_text                          └── テンプレートレンダリング    └── フッター
└── email.subject
        |
        +---> Twig Engine ---> Inky/CSSInliner ---> HTMLメール本文
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| body.html.twig（default） | `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.html.twig` | テンプレート | デフォルトテーマHTMLメールテンプレート（1行、zurb_2を継承） |
| body.html.twig（zurb_2） | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.html.twig` | テンプレート | Zurb 2テーマHTMLメールレイアウト本体（67行） |
| content_markdown.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/content_markdown.html.twig` | テンプレート | Markdownコンテンツのレンダリング（1行） |
| main.css | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/main.css` | スタイルシート | Foundation for Emails 2ベースCSS（1786行） |
| local.css | `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/local.css` | スタイルシート | 通知固有CSS（20行） |
| NotificationEmail.php | `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php` | ソース | 通知メールクラス。テンプレート変数とメール設定を管理（281行） |
